﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.IO;

namespace IPBL
{
    public static class Edge
    {
        //Edgeing by Thresholding
        static public string edge(string filename)
        {
            Bitmap bmp = new Bitmap(filename);
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            string newfilename = filename.Replace(".bmp", "_edge.bmp");


            //ماتریس لبه ها
            int[,] matris = new int[width, height];

            //لبه عمودی
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height - 1; j++)
                {
                    Color c1 = bmp.GetPixel(i, j);
                    Color c2 = bmp.GetPixel(i, j + 1);
                    if (c1 != c2 && matris[i, j] != 1) matris[i, j + 1] = 1;
                }
            }
            //لبه افقی
            for (int i = 0; i < width - 1; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c1 = bmp.GetPixel(i, j);
                    Color c2 = bmp.GetPixel(i + 1, j);
                    if (c1 != c2 && matris[i, j] != 1) matris[i + 1, j] = 1;
                }
            }
            //ذخیره ماتریس در تصویر

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    bmpnew.SetPixel(i, j, matris[i, j] == 1 ? Color.White : Color.Black);


            bmpnew.Save(newfilename);

            bmp.Dispose();
            bmpnew.Dispose();

            return newfilename;
        }
        static public Bitmap edge(ref Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            //ماتریس لبه ها
            int[,] matris = new int[width, height];

            //لبه عمودی
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height - 1; j++)
                {
                    Color c1 = bmp.GetPixel(i, j);
                    Color c2 = bmp.GetPixel(i, j + 1);
                    if (c1 != c2 && matris[i, j] != 1) matris[i, j + 1] = 1;
                }
            }
            //لبه افقی
            for (int i = 0; i < width - 1; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c1 = bmp.GetPixel(i, j);
                    Color c2 = bmp.GetPixel(i + 1, j);
                    if (c1 != c2 && matris[i, j] != 1) matris[i + 1, j] = 1;
                }
            }
            //ذخیره ماتریس در تصویر

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    bmpnew.SetPixel(i, j, matris[i, j] == 1 ? Color.White : Color.Black);

            return bmpnew;
        }
        static public Bitmap edge(Bitmap bmp, string thresh)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);
            int threshold;
            try{ threshold = int.Parse(thresh); }
            catch{ return null; }
            //ماتریس لبه ها
            int[,] matris = new int[width, height];

            //لبه عمودی
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height - 1; j++)
                {
                    Color c1 = bmp.GetPixel(i, j);
                    Color c2 = bmp.GetPixel(i, j + 1);
                    if (c1 != c2 && matris[i, j] != 1)
                        matris[i, j + 1] = c1.R - c2.R;
                }
            }
            //لبه افقی
            for (int i = 0; i < width - 1; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c1 = bmp.GetPixel(i, j);
                    Color c2 = bmp.GetPixel(i + 1, j);
                    if (c1 != c2 && matris[i, j] != 1)
                        matris[i + 1, j] = c1.R - c2.R;
                }
            }
            //ذخیره ماتریس در تصویر

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    bmpnew.SetPixel(i, j, matris[i, j] > threshold ? Color.White : Color.Black);


            //bmp.Dispose();
            //bmpnew.Dispose();

            return bmpnew;
        }
        static public Bitmap H_edge(Bitmap bmp, string thresh)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);
            int threshold;
            try { threshold = int.Parse(thresh); }
            catch { return null; }
            //ماتریس لبه ها
            int[,] matris = new int[width, height];

            //لبه عمودی
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height - 1; j++)
                {
                    Color c1 = bmp.GetPixel(i, j);
                    Color c2 = bmp.GetPixel(i, j + 1);
                    if (c1 != c2 && matris[i, j] != 1)
                        matris[i, j + 1] = c1.R - c2.R;
                }
            }
            //لبه افقی
            for (int i = 0; i < width - 1; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c1 = bmp.GetPixel(i, j);
                    Color c2 = bmp.GetPixel(i + 1, j);
                    if (c1 != c2 && matris[i, j] != 1)
                        matris[i + 1, j] = c1.R - c2.R;
                }
            }
            //ذخیره ماتریس در تصویر

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    bmpnew.SetPixel(i, j, matris[i, j] > threshold ? Color.White : Color.Black);


            //bmp.Dispose();
            //bmpnew.Dispose();

            return bmpnew;
        }
        static public Bitmap V_edge(Bitmap bmp, string thresh)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);
            int threshold;
            try { threshold = int.Parse(thresh); }
            catch { return null; }
            //ماتریس لبه ها
            int[,] matris = new int[width, height];

            //لبه افقی
            for (int i = 0; i < width - 1; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c1 = bmp.GetPixel(i, j);
                    Color c2 = bmp.GetPixel(i + 1, j);
                    if (c1 != c2 && matris[i, j] != 1)
                        matris[i + 1, j] = c1.R - c2.R;
                }
            }
            //ذخیره ماتریس در تصویر

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    bmpnew.SetPixel(i, j, matris[i, j] > threshold ? Color.White : Color.Black);


            //bmp.Dispose();
            //bmpnew.Dispose();

            return bmpnew;
        }

        //Edging by Convolution
        /// <summary>
        /// this function is supported on IPCL!
        /// </summary>
        public static string SOBEL_3D(string filename, string angel) { return null; }
        public static string SobelEdge(string filename)
        {
            Bitmap image = new Bitmap(filename);
            int[, ,] imagematris = Matris.Load.Matris3DFromeBMP_(ref image);
            imagematris = SobelEdge(ref imagematris, image.Width, image.Height);

            string newfilename = filename.Replace(".bmp", "_SobelEdge.bmp");
            Matris.Save.Matris3DToBMPFile(ref imagematris, image.Width, image.Height, newfilename);

            return newfilename;
        }
        public static int[, ,] SobelEdge(ref int[, ,] image, int width, int height)
        {
            int[, ,] newimage = new int[width, height, 3];

            int dxR = 0, dxG = 0, dxB = 0, dyR = 0, dyG = 0, dyB = 0;
            for (int i = 1; i < width - 1; i++)
            {
                for (int j = 1; j < height - 1; j++)
                {
                    dxR =
                        image[i - 1, j - 1, 0] - image[i + 1, j - 1, 0] +
                        2 * (image[i - 1, j, 0] - image[i + 1, j, 0]) +
                        image[i - 1, j - 1, 0] - image[i + 1, j + 1, 0];
                    dxG =
                        image[i - 1, j - 1, 1] - image[i + 1, j - 1, 1] +
                        2 * (image[i - 1, j, 1] - image[i + 1, j, 1]) +
                        image[i - 1, j - 1, 1] - image[i + 1, j + 1, 1];
                    dxB =
                        image[i - 1, j - 1, 2] - image[i + 1, j - 1, 2] +
                        2 * (image[i - 1, j, 2] - image[i + 1, j, 2]) +
                        image[i - 1, j - 1, 2] - image[i + 1, j + 1, 2];

                    dyR =
                        image[i - 1, j - 1, 0] - image[i - 1, j + 1, 0] +
                        2 * (image[i, j - 1, 0] - image[i, j + 1, 0]) +
                        image[i + 1, j - 1, 0] - image[i + 1, j + 1, 0];
                    dyG =
                        image[i - 1, j - 1, 1] - image[i - 1, j + 1, 1] +
                        2 * (image[i, j - 1, 1] - image[i, j + 1, 1]) +
                        image[i + 1, j - 1, 1] - image[i + 1, j + 1, 1];
                    dyB =
                        image[i - 1, j - 1, 2] - image[i - 1, j + 1, 2] +
                        2 * (image[i, j - 1, 2] - image[i, j + 1, 2]) +
                        image[i + 1, j - 1, 2] - image[i + 1, j + 1, 2];

                    newimage[i, j, 0] = Convert.ToInt32(Math.Sqrt(Math.Pow(dxR, 2) + Math.Pow(dyR, 2)));
                    newimage[i, j, 1] = Convert.ToInt32(Math.Sqrt(Math.Pow(dxG, 2) + Math.Pow(dyG, 2)));
                    newimage[i, j, 2] = Convert.ToInt32(Math.Sqrt(Math.Pow(dxB, 2) + Math.Pow(dyB, 2)));
                }
            }
            Matris.Math.ApplyThreshold(ref newimage, width, height, 255, 0);

            return newimage;
        }

        public static string DifferenceEdge(string filename)
        {
            Bitmap bmp = new Bitmap(filename);
            bmp = IPBL.Filters.rgb2gray(ref bmp, "avg");
            int width = bmp.Width, height = bmp.Height;
            int[, ,] image = Matris.Load.Matris3DFromeBMP(bmp);

            string newfilename = filename.Replace(".bmp", "_DifferenceEdge.bmp");
            DifferenceEdge(ref image, width, height).Save(newfilename);

            bmp.Dispose();
            File.Delete(filename);

            return newfilename;
        }
        public static Bitmap DifferenceEdge(ref int[, ,] image, int width, int height)
        {
            Bitmap bmpnew = new Bitmap(width, height);
            for (int i = 1; i < width - 1; i++)
            {
                for (int j = 1; j < height - 1; j++)
                {
                    int max = 0, d = 0;
                    int[,] nh = Matris.Load.NHOODS_3D(ref image, 3, i, j);
                    //left diagonals
                    d = nh[0, 0] - nh[2, 2]; if (d < 0) d *= -1; if (d > max) max = d;
                    //right diagonals
                    d = nh[2, 0] - nh[0, 2]; if (d < 0) d *= -1; if (d > max) max = d;
                    //vertical
                    d = nh[1, 0] - nh[1, 2]; if (d < 0) d *= -1; if (d > max) max = d;
                    //horizontal
                    d = nh[2, 1] - nh[0, 1]; if (d < 0) d *= -1; if (d > max) max = d;
                    //
                    bmpnew.SetPixel(i, j, Color.FromArgb(max, max, max));
                }
            }
            return bmpnew;
        }
        public static string HomogenityEdge(string filename)
        {
            Bitmap bmp = new Bitmap(filename);
            bmp = IPBL.Filters.rgb2gray(ref bmp, "avg");
            int width = bmp.Width, height = bmp.Height;
            int[, ,] image = Matris.Load.Matris3DFromeBMP(bmp);

            Bitmap bmpnew = new Bitmap(width, height);

            for (int i = 1; i < width - 1; i++)
            {
                for (int j = 1; j < height - 1; j++)
                {
                    int max = 0, d = 0;
                    int[,] nh = Matris.Load.NHOODS_3D(ref image, 3, i, j);
                    int c = nh[1, 1];
                    //top left
                    d = c - nh[0, 0]; if (d < 0) d *= -1; if (d > max) max = d;
                    //top
                    d = c - nh[0, 1]; if (d < 0) d *= -1; if (d > max) max = d;
                    //top right
                    d = c - nh[0, 2]; if (d < 0) d *= -1; if (d > max) max = d;
                    //rigth
                    d = c - nh[1, 2]; if (d < 0) d *= -1; if (d > max) max = d;
                    //right down
                    d = c - nh[2, 2]; if (d < 0) d *= -1; if (d > max) max = d;
                    //down
                    d = c - nh[2, 1]; if (d < 0) d *= -1; if (d > max) max = d;
                    //down left
                    d = c - nh[2, 0]; if (d < 0) d *= -1; if (d > max) max = d;
                    //left
                    d = c - nh[1, 0]; if (d < 0) d *= -1; if (d > max) max = d;
                    //
                    bmpnew.SetPixel(i, j, Color.FromArgb(max, max, max));
                }
            }
            string newfilename = filename.Replace(".bmp", "_HomogenityEdge.bmp");
            bmpnew.Save(newfilename);

            bmp.Dispose();
            bmpnew.Dispose();

            File.Delete(filename);

            return newfilename;
        }
        public static string Robert(string filename)
        {
            Bitmap image = new Bitmap(filename);
            int width = image.Width, height = image.Height;
            int[, ,] imagematris = Matris.Load.Matris3DFromeBMP(image);
            
            string newfilename = filename.Replace(".bmp", "_Roberto.bmp");
            imagematris = Robert(ref imagematris, width, height);
            Matris.Save.Matris3DToBMPFile(ref imagematris, width - 1, height - 1, newfilename);

            image.Dispose();

            return newfilename;
        }
        public static int[, ,] Robert(ref int[, ,] imagematris, int width, int height)
        {
            int[, ,] newimagematris = new int[width - 1, height - 1, 3];
            for (int i = 1; i < width; i++)
            {
                for (int j = 1; j < height; j++)
                {
                    newimagematris[i - 1, j - 1, 0] =
                        Math.Abs(imagematris[i - 1, j - 1, 0] - imagematris[i, j, 0]) +
                        Math.Abs(imagematris[i, j - 1, 0] - imagematris[i - 1, j, 0]);
                    newimagematris[i - 1, j - 1, 1] =
                        Math.Abs(imagematris[i - 1, j - 1, 1] - imagematris[i, j, 1]) +
                        Math.Abs(imagematris[i, j - 1, 1] - imagematris[i - 1, j, 1]);
                    newimagematris[i - 1, j - 1, 2] =
                        Math.Abs(imagematris[i - 1, j - 1, 2] - imagematris[i, j, 2]) +
                        Math.Abs(imagematris[i, j - 1, 2] - imagematris[i - 1, j, 2]);
                }
            }
            Matris.Math.ApplyThreshold(ref newimagematris, width - 1, height - 1, 255, 0);
            return newimagematris;
        }
        public static string Gradiant(string filename)
        {
            Bitmap bmp = new Bitmap(filename);
            int[, ,] image = Matris.Load.Matris3DFromeBMP_(ref bmp);

            image = Gradiant(ref image, bmp.Width, bmp.Height);

            string newfilename = filename.Replace(".bmp", "_grad.bmp");
            Matris.Save.Matris3DToBMPFile(ref image, bmp.Width, bmp.Height, newfilename);
            return newfilename;
        }
        public static int[, ,] Gradiant(ref int[, ,] imagematris, int width, int height)
        {
            int[, ,] newimagematris = new int[width + 2, height + 2, 3];
            imagematris = Matris.Edit.ExpandAndCentralize(ref imagematris, width, height, 1);

            for (int i = 1; i < width + 1; i++)
            {
                for (int j = 1; j < height + 1; j++)
                {
                    double dxr = Math.Pow(imagematris[i + 1, j, 0] - imagematris[i - 1, j, 0], 2);
                    double dxg = Math.Pow(imagematris[i + 1, j, 1] - imagematris[i - 1, j, 1], 2);
                    double dxb = Math.Pow(imagematris[i + 1, j, 2] - imagematris[i - 1, j, 2], 2);

                    double dyr = Math.Pow(imagematris[i, j + 1, 0] - imagematris[i, j - 1, 0], 2);
                    double dyg = Math.Pow(imagematris[i, j + 1, 1] - imagematris[i, j - 1, 1], 2);
                    double dyb = Math.Pow(imagematris[i, j + 1, 2] - imagematris[i, j - 1, 2], 2);

                    int gradr = Convert.ToInt32(Math.Sqrt(dxr + dyr));
                    int gradg = Convert.ToInt32(Math.Sqrt(dxg + dyg));
                    int gradb = Convert.ToInt32(Math.Sqrt(dxb + dyb));

                    newimagematris[i, j, 0] = gradr;
                    newimagematris[i, j, 2] = gradg;
                    newimagematris[i, j, 1] = gradb;
                }
            }

            newimagematris = Matris.Edit.Crop(ref newimagematris, width + 2, height + 2, 1, 1, width + 1, height + 1);
            Matris.Math.ApplyThreshold(ref newimagematris, width, height, 255, 0);

            return newimagematris;
        }

        //Corner Detections
        public static string CornerDetection(string filename, int differenceThreshold, int geometricalThreshold)
        {
            Bitmap imageData = new Bitmap(filename);
            imageData = IPBL.Filters.rgb2gray(ref imageData, "avg");

            // get source image size
            int width = imageData.Width;
            int height = imageData.Height;

            int[,] susanMap = new int[height, width];

            int[, ,] imageMatris = Matris.Load.Matris3DFromeBMP(imageData);

            int[] rowRadius = new int[7] { 1, 2, 3, 3, 3, 2, 1 };

            // for each row
            for (int y = 3, maxY = height - 3; y < maxY; y++)
            {
                // for each pixel
                for (int x = 3, maxX = width - 3; x < maxX; x++)
                {
                    // usan - number of pixels with similar brightness
                    int usan = 0;
                    // center of gravity
                    int cx = 0, cy = 0;

                    // for each row of the mask
                    for (int i = -3; i <= 3; i++)
                    {
                        // determine row's radius
                        int r = rowRadius[i + 3];

                        // get pointer to the central pixel of the row
                        //byte* ptr = src + stride * i;

                        // for each element of the mask's row
                        for (int j = -r; j <= r; j++)
                        {
                            // differenceThreshold
                            if (System.Math.Abs(imageMatris[x, y, 0] - imageMatris[x + i, y + j, 0]) <= differenceThreshold)
                            {
                                usan++;

                                cx += x + j;
                                cy += y + i;
                            }
                        }
                    }

                    // check usan size
                    if (usan < geometricalThreshold)
                    {
                        cx /= usan;
                        cy /= usan;

                        if ((x != cx) || (y != cy))
                        {
                            // cornersList.Add( new Point( x, y ) );
                            usan = (geometricalThreshold - usan);
                        }
                        else
                        {
                            usan = 0;
                        }
                    }
                    else
                    {
                        usan = 0;
                    }

                    // usan = ( usan < geometricalThreshold ) ? ( geometricalThreshold - usan ) : 0;
                    susanMap[y, x] = usan;
                }//j

            }//i



            // collect interesting points - only those points, which are local maximums
            List<Point> cornersList = new List<Point>();

            // for each row
            for (int y = 2, maxY = height - 2; y < maxY; y++)
            {
                // for each pixel
                for (int x = 2, maxX = width - 2; x < maxX; x++)
                {
                    int currentValue = susanMap[y, x];

                    // for each windows' row
                    for (int i = -2; (currentValue != 0) && (i <= 2); i++)
                    {
                        // for each windows' pixel
                        for (int j = -2; j <= 2; j++)
                        {
                            if (susanMap[y + i, x + j] > currentValue)
                            {
                                currentValue = 0;
                                break;
                            }
                        }
                    }

                    // check if this point is really interesting
                    if (currentValue != 0)
                    {
                        cornersList.Add(new Point(x, y));
                    }
                }//i
            }//i

            // convert list to array
            Point[] corners = new Point[cornersList.Count];
            cornersList.CopyTo(corners);

            int pc = cornersList.Count;
            for (int i = 0; i < pc; i++) { imageData.SetPixel(cornersList.ElementAt(i).X, cornersList.ElementAt(i).Y, Color.Red); }

            string newfilename = filename.Replace(".bmp", "_Corners-" + differenceThreshold.ToString() + "-" + geometricalThreshold.ToString() + ".bmp");
            imageData.Save(newfilename);
            return newfilename;
        }//function corner detectoin
    }//class edge
}
